package gov.va.med.domain.model;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * @hibernate.class table="MESSAGING_REQUESTS"
 *  
 */
public class MessagingRequest extends gov.va.med.domain.model.DomainObject
        implements Serializable
{

    public static final String STATUS_NEW = "N";

    public static final String STATUS_TRANSMITTED = "T";

    public static final String STATUS_FAILED_TRANSMISSION = "SE";

    public static final String STATUS_PARTIALLY_RECEIVED = "PR";

    public static final String STATUS_RECEIVED = "RE";

    public static final String STATUS_FAILED = "PE";

    public static final String STATUS_COMPLETE = "C";

    public static final String STATUS_COMPLETE_STALE = "CS";

    /** persistent field */
    private Long institutionId;

    /** persistent field */
    private String messagingRequestStatus;

    /** nullable persistent field */
    private String messageId;

    /** persistent field */
    private Date messagingRequestStatusDate;

    /** nullable persistent field */
    private Long recordsReceived;

    /** nullable persistent field */
    private Long expectedRecords;

    /** nullable persistent field */
    private Long responseSize;

    /** nullable persistent field */
    private Date startDate;

    /** nullable persistent field */
    private Date endDate;

    /** nullable persistent field */
    private Date modifiedDate;

    /** persistent field */
    private gov.va.med.domain.model.Function function;

    /** persistent field */
    private gov.va.med.domain.model.PatientMessagingRequest patientMessagingRequest;

    /** persistent field */
    private Set messageErrors;

    /** persistent field */
    private Set messageInventories;

    /** persistent field */
    private Set messageCaches;

    /** full constructor */
    public MessagingRequest(
            Long institutionId,
            String messagingRequestStatus,
            Date messagingRequestStatusDate,
            Long recordsReceived,
            Long expectedRecords,
            Long responseSize,
            Date startDate,
            Date endDate,
            Date createdDate,
            Date modifiedDate,
            gov.va.med.domain.model.Function function,
            gov.va.med.domain.model.PatientMessagingRequest patientMessagingRequest,
            Set messageErrors, Set messageInventories, Set messageCaches)
    {
        this.institutionId = institutionId;
        this.messagingRequestStatus = messagingRequestStatus;
        this.messagingRequestStatusDate = messagingRequestStatusDate;
        this.recordsReceived = recordsReceived;
        this.expectedRecords = expectedRecords;
        this.responseSize = responseSize;
        this.startDate = startDate;
        this.endDate = endDate;
        this.setCreatedDate(createdDate);
        this.modifiedDate = modifiedDate;
        this.function = function;
        this.patientMessagingRequest = patientMessagingRequest;
        this.messageErrors = messageErrors;
        this.messageInventories = messageInventories;
        this.messageCaches = messageCaches;
    }

    /** default constructor */
    public MessagingRequest()
    {
    }

    /** minimal constructor */
    public MessagingRequest(
            Long institutionId,
            String messagingRequestStatus,
            Date messagingRequestStatusDate,
            Date createdDate,
            gov.va.med.domain.model.Function function,
            gov.va.med.domain.model.PatientMessagingRequest patientMessagingRequest,
            Set messageErrors, Set messageInventories, Set messageCaches)
    {
        this.institutionId = institutionId;
        this.messagingRequestStatus = messagingRequestStatus;
        this.messagingRequestStatusDate = messagingRequestStatusDate;
        this.setCreatedDate(createdDate);
        this.function = function;
        this.patientMessagingRequest = patientMessagingRequest;
        this.messageErrors = messageErrors;
        this.messageInventories = messageInventories;
        this.messageCaches = messageCaches;
    }

    /**
     * @hibernate.property column="INSTITUTION_ID" length="20" not-null="true"
     *  
     */
    public Long getInstitutionId()
    {
        return this.institutionId;
    }

    public void setInstitutionId(Long institutionId)
    {
        this.institutionId = institutionId;
    }

    /**
     * @hibernate.property column="MESSAGING_REQUEST_STATUS" length="6"
     *                     not-null="true"
     *  
     */
    public String getMessagingRequestStatus()
    {
        return this.messagingRequestStatus;
    }

    public void setMessagingRequestStatus(String messagingRequestStatus)
    {
        this.messagingRequestStatus = messagingRequestStatus;
        Date dt = new Date();
        this.setMessagingRequestStatusDate(dt);
        this.setModifiedDate(dt);
    }

    /**
     * @hibernate.property column="MESSAGING_REQUEST_STATUS_DATE" length="7"
     *                     not-null="true"
     *  
     */
    public Date getMessagingRequestStatusDate()
    {
        return this.messagingRequestStatusDate;
    }

    public void setMessagingRequestStatusDate(Date messagingRequestStatusDate)
    {
        this.messagingRequestStatusDate = messagingRequestStatusDate;
    }

    /**
     * @hibernate.property column="RECORDS_RECEIVED" length="22"
     *  
     */
    public Long getRecordsReceived()
    {
        return this.recordsReceived;
    }

    public long getRecordsReceivedLongValue()
    {
        if (getRecordsReceived() == null)
        {
            return 0l;
        }
        return getRecordsReceived().longValue();
    }

    public void setRecordsReceived(Long recordsReceived)
    {
        this.recordsReceived = recordsReceived;
    }

    /**
     * @hibernate.property column="EXPECTED_RECORDS" length="22"
     *  
     */
    public Long getExpectedRecords()
    {
        return this.expectedRecords;
    }

    public void setExpectedRecords(Long expectedRecords)
    {
        this.expectedRecords = expectedRecords;
    }

    /**
     * @hibernate.property column="RESPONSE_SIZE" length="22"
     *  
     */
    public Long getResponseSize()
    {
        return this.responseSize;
    }

    public void setResponseSize(Long responseSize)
    {
        this.responseSize = responseSize;
    }

    /**
     * @hibernate.property column="START_DATE" length="7"
     *  
     */
    public Date getStartDate()
    {
        return this.startDate;
    }

    public void setStartDate(Date startDate)
    {
        this.startDate = startDate;
    }

    /**
     * @hibernate.property column="END_DATE" length="7"
     *  
     */
    public Date getEndDate()
    {
        return this.endDate;
    }

    public void setEndDate(Date endDate)
    {
        this.endDate = endDate;
    }

    /**
     * @hibernate.property column="MODIFIED_DATE" length="7"
     *  
     */
    public Date getModifiedDate()
    {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate)
    {
        this.modifiedDate = modifiedDate;
    }

    /**
     * @hibernate.many-to-one not-null="true"
     * @hibernate.column name="FUNCTION_ID_SEQ"
     *  
     */
    public gov.va.med.domain.model.Function getFunction()
    {
        return this.function;
    }

    public void setFunction(gov.va.med.domain.model.Function function)
    {
        this.function = function;
    }

    /**
     * @hibernate.many-to-one not-null="true"
     * @hibernate.column name="PATIENT_MESSAGING_RQST_ID_SEQ"
     *  
     */
    public gov.va.med.domain.model.PatientMessagingRequest getPatientMessagingRequest()
    {
        return this.patientMessagingRequest;
    }

    public void setPatientMessagingRequest(
            gov.va.med.domain.model.PatientMessagingRequest patientMessagingRequest)
    {
        this.patientMessagingRequest = patientMessagingRequest;
    }

    /**
     * @hibernate.set lazy="true" inverse="true" cascade="none"
     * @hibernate.collection-key column="MESSAGING_REQUEST_ID_SEQ"
     * @hibernate.collection-one-to-many class="gov.va.med.domain.model.MessageError"
     *  
     */
    public Set getMessageErrors()
    {
        return this.messageErrors;
    }

    public void setMessageErrors(Set messageErrors)
    {
        this.messageErrors = messageErrors;
    }

    /**
     * @hibernate.set lazy="true" inverse="true" cascade="none"
     * @hibernate.collection-key column="MESSAGING_REQUEST_ID_SEQ"
     * @hibernate.collection-one-to-many class="gov.va.med.domain.model.MessageInventory"
     *  
     */
    public Set getMessageInventories()
    {
        return this.messageInventories;
    }

    public void setMessageInventories(Set messageInventories)
    {
        this.messageInventories = messageInventories;
    }

    /**
     * @hibernate.set lazy="true" inverse="true" cascade="none"
     * @hibernate.collection-key column="MESSAGING_REQUEST_ID_SEQ"
     * @hibernate.collection-one-to-many class="gov.va.med.domain.model.MessageCache"
     *  
     */
    public Set getMessageCaches()
    {
        return this.messageCaches;
    }

    public void setMessageCaches(Set messageCaches)
    {
        this.messageCaches = messageCaches;
    }

    public String toString()
    {
        return new ToStringBuilder(this).append("id", getId()).append(
                "institutionId", getInstitutionId()).append(
                "messagingRequestStatus", getMessagingRequestStatus()).append(
                "messagingRequestStatusDate", getMessagingRequestStatusDate())
                .append("recordsReceived", getRecordsReceived()).append(
                        "expectedRecords", getExpectedRecords()).append(
                        "responseSize", getResponseSize()).append("startDate",
                        getStartDate()).append("endDate", getEndDate()).append(
                        "createdDate", getCreatedDate()).append("modifiedDate",
                        getModifiedDate()).append("versionNumber",
                        getVersionNumber()).toString();
    }

    public String getCategoryCode()
    {
        CategoryType categoryType = getFunction().getCategoryType();
        return categoryType==null?null:(String)categoryType.getId();
    }

    public String getIcn()
    {
        return getPatientMessagingRequest().getIcn();
    }

    public long getUserId()
    {
        return getPatientMessagingRequest().getUserId().longValue();
    }

    /**
     * @return Returns the messageId.
     */
    public String getMessageId()
    {
        return messageId;
    }

    /**
     * @param messageId The messageId to set.
     */
    public void setMessageId(String messageId)
    {
        this.messageId = messageId;
    }
}
